<?php
include 'koneksi.php';
include 'header1.php';

// **1. Ambil Data dari Database (SESUDAH DIREVISI KE TABEL MAHASISWA)**
$query_alternatif = mysqli_query($conn, "SELECT * FROM mahasiswa");
$nilai_alternatif = [];
while ($row = mysqli_fetch_assoc($query_alternatif)) {
    $nilai_alternatif[] = $row;
}

// **2. Definisi Nama Kriteria**
$kriteria_nama = [
    "c1" => "Relevansi Konten",
    "c2" => "Kualitas Penyampaian",
    "c3" => "Kualitas Audiovisual",
    "c4" => "Interaktivitas & Engagement",
    "c5" => "Frekuensi Penggunaan",
    "c6" => "Hambatan Akses",
    "c7" => "Dampak terhadap Pemahaman"
];

// **3. Hitung Rata-rata Nilai per Alternatif**
$rata_per_alternatif = [];
$total_rata_rata = 0;
$total_alternatif = count($nilai_alternatif);

foreach ($nilai_alternatif as $alt) {
    $total_nilai = 0;
    $jumlah_kriteria = count($kriteria_nama);
    
    foreach ($kriteria_nama as $key => $nama) {
        $total_nilai += $alt[$key];
    }
    
    $rata_rata = $total_nilai / $jumlah_kriteria;
    $rata_per_alternatif[] = [
        "alternatif" => $alt["alternatif"],
        "rata_rata" => $rata_rata
    ];
    
    $total_rata_rata += $rata_rata;
}

// **4. Hitung Total Rata-rata Seluruh Alternatif**
$total_rata_rata /= $total_alternatif;
?>


<style>
    /* Pastikan kontainer utama fleksibel */
    #layoutSidenav {
        display: flex;
        transition: all 0.3s ease-in-out;
    }

    #layoutSidenav_content {
        flex-grow: 1;
        transition: all 0.3s ease-in-out;
    }

    /* Pastikan tabel fleksibel */
    .table-responsive {
        width: 100%;
        transition: all 0.3s ease-in-out;
    }

    /* Jika sidebar ditutup, kontainer utama melebar */
    body.sb-sidenav-toggled #layoutSidenav_content {
        margin-left: 0;
        width: calc(100% - 0px);
    }

    /* Pastikan tabel ikut melebar */
    body.sb-sidenav-toggled .table-responsive {
        width: 100%;
    }
</style>

<div id="layoutSidenav_content">
    <main>
        <div class="container-fluid mt-4">
            <h2 class="text-center mb-4 py-3 bg-light rounded"><strong>ANALISIS RATA-RATA NILAI ALTERNATIF</strong></h2>

            <!-- **Tabel Nilai Mahasiswa/Alternatif** -->
            <div class="card shadow-sm w-100">
                <div class="card-header bg-primary text-white text-center">
                    <h4><i class="fas fa-clipboard-list"></i>  Data Nilai Mahasiswa</h4>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered text-center w-100">
                            <thead class="table-primary">
                                <tr>
                                    <th>No.</th>
                                    <th>Nama Mahasiswa</th>
                                    <?php foreach ($kriteria_nama as $key => $nama) : ?>
                                        <th><?= $nama; ?></th>
                                    <?php endforeach; ?>
                                </tr>
                            </thead>
                            <tbody class="table-light">
                                <?php $no = 1; ?>
                                <?php foreach ($nilai_alternatif as $row) : ?>
                                    <tr>
                                        <td><?= $no++; ?></td>
                                        <td><?= htmlspecialchars($row["alternatif"]); ?></td>
                                        <?php foreach ($kriteria_nama as $key => $nama) : ?>
                                            <td><?= number_format($row[$key], 0); ?></td>
                                        <?php endforeach; ?>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <br><br>

            <!-- **Tabel Analisis Rata-rata** -->
            <div class="card shadow-sm w-100">
                <div class="card-header bg-primary text-white text-center">
                    <h4><i class="fas fa-chart-line"></i> Nilai Rata-rata</h4>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered text-center w-100">
                            <thead class="table-primary">
                                <tr>
                                    <th>No.</th>
                                    <th>Nama Mahasiswa</th>
                                    <th>Rata-rata Nilai</th>
                                </tr>
                            </thead>
                            <tbody class="table-light">
                                <?php $no = 1; ?>
                                <?php foreach ($rata_per_alternatif as $alt) : ?>
                                    <tr>
                                        <td><?= $no++; ?></td>
                                        <td><?= htmlspecialchars($alt["alternatif"]); ?></td>
                                        <td><?= number_format($alt["rata_rata"], 2); ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                            <tfoot class="table-dark">
                                <tr>
                                    <th colspan="2" class="text-center" style="text-size-adjust: 20px;">Total Rata-rata Seluruh Alternatif</th>
                                    <th><?= number_format($total_rata_rata, 2); ?></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>

            <br><br>

            <!-- **Kesimpulan Analisis** -->
            <div class="text-center">
                <h4>Kesimpulan Rata-rata</h4>
            </div>
            <div class="card-body">
                <p class="text-justify" style="font-size: 18px;">
                    Berdasarkan hasil perhitungan rata-rata nilai alternatif, diperoleh total rata-rata nilai seluruh mahasiswa sebesar 
                    <b style="color: red;"><?= number_format($total_rata_rata, 2); ?></b>. 
                    Hasil ini menunjukkan bahwa efektivitas YouTube sebagai media pembelajaran bagi mahasiswa Teknik Informatika berada pada tingkat yang cukup tinggi.
                </p>

                <p class="text-justify" style="font-size: 18px;">
                    Jika nilai rata-rata ini berada di atas <b>75</b>, maka dapat disimpulkan bahwa secara umum YouTube efektif sebagai media pembelajaran. 
                    Namun, hasil ini masih bersifat umum dan belum cukup untuk menarik kesimpulan akhir. Oleh karena itu, diperlukan perhitungan lebih lanjut menggunakan metode Weighted Product (WP)
                    guna memperoleh hasil yang lebih objektif dan mempertimbangkan bobot masing-masing kriteria dalam penilaian efektivitas pembelajaran.
                </p>

                <p class="text-justify" style="font-size: 18px;">
                    Dengan metode WP, kita dapat menentukan nilai akhir yang paling optimal berdasarkan bobot kriteria yang telah ditetapkan. 
                    Proses ini akan memberikan rekomendasi yang lebih akurat dalam memilih sumber pembelajaran terbaik di YouTube untuk mahasiswa Teknik Informatika.
                </p>
                <br><br>

                <!-- Tombol Mulai Perhitungan WP -->
                <div class="text-center">
                    <a href="proses1.php" class="btn btn-lg btn-outline-primary">
                        <i class="fas fa-calculator"></i> Mulai Perhitungan Metode Weighted Product
                    </a>
                </div>
            </div>

            <br><br>
        </div>
    </main>
</div>

<!-- 🔥 JavaScript untuk Sidebar Toggle -->
<script>
    document.addEventListener("DOMContentLoaded", function () {
        let sidebarToggle = document.querySelector("#sidebarToggle");
        sidebarToggle.addEventListener("click", function () {
            document.body.classList.toggle("sb-sidenav-toggled");
        });
    });
</script>
